/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.model;

import rpgboss.lib.StringUtils$;
import rpgboss.model.AddStatusEffect$;
import rpgboss.model.ArmAdd$;
import rpgboss.model.AtkAdd$;
import rpgboss.model.Damage;
import rpgboss.model.DamageType$;
import rpgboss.model.Effect;
import rpgboss.model.EffectContext$;
import rpgboss.model.EffectUsability;
import rpgboss.model.EscapeBattle$;
import rpgboss.model.HasName;
import rpgboss.model.InvalidEffect$;
import rpgboss.model.LearnSkill$;
import rpgboss.model.MagAdd$;
import rpgboss.model.MetaEffect;
import rpgboss.model.MhpAdd$;
import rpgboss.model.MmpAdd$;
import rpgboss.model.MreAdd$;
import rpgboss.model.ProjectData;
import rpgboss.model.RecoverHpAdd$;
import rpgboss.model.RecoverHpMul$;
import rpgboss.model.RecoverMpAdd$;
import rpgboss.model.RecoverMpMul$;
import rpgboss.model.RemoveAllStatusEffect$;
import rpgboss.model.RemoveStatusEffect$;
import rpgboss.model.ResistElement$;
import rpgboss.model.SpdAdd$;
import rpgboss.model.UseSkill$;
import rpgboss.model.battle.BattleStatus;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

public final class Effect$
implements Serializable {
    public static final Effect$ MODULE$;
    private Map<Object, MetaEffect> _metaEffects;

    static {
        new Effect$();
    }

    private Map<Object, MetaEffect> _metaEffects() {
        return this._metaEffects;
    }

    private void _metaEffects_$eq(Map<Object, MetaEffect> x$1) {
        this._metaEffects = x$1;
    }

    public Option<MetaEffect> registerMetaEffect(int id, MetaEffect metaEffect) {
        Predef$.MODULE$.assert(!this._metaEffects().contains(BoxesRunTime.boxToInteger(id)));
        return this._metaEffects().put(BoxesRunTime.boxToInteger(id), metaEffect);
    }

    public MetaEffect getMeta(int keyId) {
        MetaEffect metaEffect;
        int n = keyId;
        switch (n) {
            default: {
                metaEffect = this._metaEffects().getOrElse(BoxesRunTime.boxToInteger(n), new Serializable(){

                    public final InvalidEffect$ apply() {
                        return InvalidEffect$.MODULE$;
                    }
                });
                break;
            }
            case 16: {
                metaEffect = UseSkill$.MODULE$;
                break;
            }
            case 15: {
                metaEffect = LearnSkill$.MODULE$;
                break;
            }
            case 14: {
                metaEffect = EscapeBattle$.MODULE$;
                break;
            }
            case 13: {
                metaEffect = ResistElement$.MODULE$;
                break;
            }
            case 12: {
                metaEffect = MreAdd$.MODULE$;
                break;
            }
            case 11: {
                metaEffect = ArmAdd$.MODULE$;
                break;
            }
            case 10: {
                metaEffect = MagAdd$.MODULE$;
                break;
            }
            case 9: {
                metaEffect = SpdAdd$.MODULE$;
                break;
            }
            case 8: {
                metaEffect = AtkAdd$.MODULE$;
                break;
            }
            case 7: {
                metaEffect = MmpAdd$.MODULE$;
                break;
            }
            case 6: {
                metaEffect = MhpAdd$.MODULE$;
                break;
            }
            case 5: {
                metaEffect = RemoveStatusEffect$.MODULE$;
                break;
            }
            case 4: {
                metaEffect = AddStatusEffect$.MODULE$;
                break;
            }
            case 3: {
                metaEffect = RecoverMpMul$.MODULE$;
                break;
            }
            case 2: {
                metaEffect = RecoverMpAdd$.MODULE$;
                break;
            }
            case 1: {
                metaEffect = RecoverHpMul$.MODULE$;
                break;
            }
            case 0: {
                metaEffect = RecoverHpAdd$.MODULE$;
            }
        }
        return metaEffect;
    }

    public String pointRenderer(ProjectData pData, Effect effect) {
        return new StringOps(Predef$.MODULE$.augmentString("%dp")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(effect.v1())}));
    }

    public String percentRenderer(ProjectData pData, Effect effect) {
        return new StringOps(Predef$.MODULE$.augmentString("%d%%")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(effect.v1())}));
    }

    public <T extends HasName> String getEnumOfValue1(Function1<ProjectData, T[]> getChoices, ProjectData pData, Effect effect) {
        HasName[] choices = (HasName[])getChoices.apply(pData);
        String name = effect.v1() < choices.length ? choices[effect.v1()].name() : "<Past end of array>";
        return StringUtils$.MODULE$.standardIdxFormat(effect.v1(), name);
    }

    public <T extends HasName> String getEnumWithExtraValue(Function1<ProjectData, T[]> getChoices, ProjectData pData, Effect effect) {
        String value1string = this.getEnumOfValue1(getChoices, pData, effect);
        return new StringOps(Predef$.MODULE$.augmentString("%s. Value = %d ")).format(Predef$.MODULE$.genericWrapArray(new Object[]{value1string, BoxesRunTime.boxToInteger(effect.v2())}));
    }

    public EffectUsability recoveryHelp(Enumeration.Value context) {
        EffectUsability effectUsability;
        Enumeration.Value value2 = context;
        Enumeration.Value value3 = EffectContext$.MODULE$.Item();
        Enumeration.Value value4 = value2;
        if (!(value3 != null ? !((Object)value3).equals(value4) : value4 != null)) {
            effectUsability = new EffectUsability(true, "One-time effect of item use.");
        } else {
            Enumeration.Value value5 = EffectContext$.MODULE$.Skill();
            Enumeration.Value value6 = value2;
            if (!(value5 != null ? !((Object)value5).equals(value6) : value6 != null)) {
                effectUsability = new EffectUsability(true, "One-time effect of skill use.");
            } else {
                Enumeration.Value value7 = EffectContext$.MODULE$.StatusEffect();
                Enumeration.Value value8 = value2;
                effectUsability = !(value7 != null ? !((Object)value7).equals(value8) : value8 != null) ? new EffectUsability(true, "Applies per tick.") : new EffectUsability(false, "Doesn't do anything.");
            }
        }
        return effectUsability;
    }

    public EffectUsability itemEquipSkillOnlyHelp(Enumeration.Value context) {
        EffectUsability effectUsability;
        Enumeration.Value value2 = context;
        Enumeration.Value value3 = EffectContext$.MODULE$.Item();
        Enumeration.Value value4 = value2;
        if (!(value3 != null ? !((Object)value3).equals(value4) : value4 != null)) {
            effectUsability = new EffectUsability(true, "One-time effect of item use.");
        } else {
            Enumeration.Value value5 = EffectContext$.MODULE$.Equipment();
            Enumeration.Value value6 = value2;
            if (!(value5 != null ? !((Object)value5).equals(value6) : value6 != null)) {
                effectUsability = new EffectUsability(true, "Occurs once per hit.");
            } else {
                Enumeration.Value value7 = EffectContext$.MODULE$.Skill();
                Enumeration.Value value8 = value2;
                effectUsability = !(value7 != null ? !((Object)value7).equals(value8) : value8 != null) ? new EffectUsability(true, "One-time effect of skill use.") : new EffectUsability(false, "Doesn't do anything.");
            }
        }
        return effectUsability;
    }

    public EffectUsability classEquipOrStatus(Enumeration.Value context) {
        EffectUsability effectUsability;
        Enumeration.Value value2 = context;
        Enumeration.Value value3 = EffectContext$.MODULE$.CharacterClass();
        Enumeration.Value value4 = value2;
        if (!(value3 != null ? !((Object)value3).equals(value4) : value4 != null)) {
            effectUsability = new EffectUsability(true, "Permanently has resistance.");
        } else {
            Enumeration.Value value5 = EffectContext$.MODULE$.Equipment();
            Enumeration.Value value6 = value2;
            if (!(value5 != null ? !((Object)value5).equals(value6) : value6 != null)) {
                effectUsability = new EffectUsability(true, "Confers resistance on equipper.");
            } else {
                Enumeration.Value value7 = EffectContext$.MODULE$.StatusEffect();
                Enumeration.Value value8 = value2;
                effectUsability = !(value7 != null ? !((Object)value7).equals(value8) : value8 != null) ? new EffectUsability(true, "Confers resistance while active.") : new EffectUsability(false, "Doesn't do anything.");
            }
        }
        return effectUsability;
    }

    public EffectUsability onItemAndSkillHelp(Enumeration.Value context) {
        EffectUsability effectUsability;
        Enumeration.Value value2 = context;
        Enumeration.Value value3 = EffectContext$.MODULE$.Item();
        Enumeration.Value value4 = value2;
        if (!(value3 != null ? !((Object)value3).equals(value4) : value4 != null)) {
            effectUsability = new EffectUsability(true, "One-time effect of item use.");
        } else {
            Enumeration.Value value5 = EffectContext$.MODULE$.Skill();
            Enumeration.Value value6 = value2;
            effectUsability = !(value5 != null ? !((Object)value5).equals(value6) : value6 != null) ? new EffectUsability(true, "One-time effect of skill use.") : new EffectUsability(false, "Doesn't do anything.");
        }
        return effectUsability;
    }

    public EffectUsability onItemOnlyHelp(Enumeration.Value context) {
        Enumeration.Value value2 = context;
        Enumeration.Value value3 = EffectContext$.MODULE$.Item();
        Enumeration.Value value4 = value2;
        EffectUsability effectUsability = !(value3 != null ? !((Object)value3).equals(value4) : value4 != null) ? new EffectUsability(true, "One-time effect of item use.") : new EffectUsability(false, "Doesn't do anything.");
        return effectUsability;
    }

    public EffectUsability onItemAndEquipHelp(Enumeration.Value context) {
        EffectUsability effectUsability;
        Enumeration.Value value2 = context;
        Enumeration.Value value3 = EffectContext$.MODULE$.Item();
        Enumeration.Value value4 = value2;
        if (!(value3 != null ? !((Object)value3).equals(value4) : value4 != null)) {
            effectUsability = new EffectUsability(true, "One-time effect of item use.");
        } else {
            Enumeration.Value value5 = EffectContext$.MODULE$.Equipment();
            Enumeration.Value value6 = value2;
            effectUsability = !(value5 != null ? !((Object)value5).equals(value6) : value6 != null) ? new EffectUsability(true, "Occurs once per hit.") : new EffectUsability(false, "Doesn't do anything.");
        }
        return effectUsability;
    }

    public Seq<Damage> recoverHp(BattleStatus target, double amount) {
        if (target.alive()) {
            int amountInt = (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(amount));
            target.hp_$eq(target.hp() + amountInt);
            return List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Damage[]{new Damage(DamageType$.MODULE$.Magic(), 0, -amountInt)}));
        }
        return Nil$.MODULE$;
    }

    public List<Damage> recoverMp(BattleStatus target, double amount) {
        int amountInt = (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(amount));
        target.mp_$eq(target.mp() + amountInt);
        return List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Damage[]{new Damage(DamageType$.MODULE$.MPDamage(), 0, -amountInt)}));
    }

    public Effect apply(int keyId, int v1, int v2) {
        return new Effect(keyId, v1, v2);
    }

    public Option<Tuple3<Object, Object, Object>> unapply(Effect x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple3<Integer, Integer, Integer>>(new Tuple3<Integer, Integer, Integer>(BoxesRunTime.boxToInteger(x$0.keyId()), BoxesRunTime.boxToInteger(x$0.v1()), BoxesRunTime.boxToInteger(x$0.v2())));
    }

    public int $lessinit$greater$default$2() {
        return 0;
    }

    public int $lessinit$greater$default$3() {
        return 0;
    }

    public int apply$default$2() {
        return 0;
    }

    public int apply$default$3() {
        return 0;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Effect$() {
        MODULE$ = this;
        this._metaEffects = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        Object[] cfr_ignored_0 = new MetaEffect[]{RecoverHpAdd$.MODULE$, RecoverHpMul$.MODULE$, RecoverMpAdd$.MODULE$, RecoverMpMul$.MODULE$, AddStatusEffect$.MODULE$, RemoveStatusEffect$.MODULE$, RemoveAllStatusEffect$.MODULE$, MhpAdd$.MODULE$, MmpAdd$.MODULE$, AtkAdd$.MODULE$, SpdAdd$.MODULE$, MagAdd$.MODULE$, ArmAdd$.MODULE$, MreAdd$.MODULE$, ResistElement$.MODULE$, EscapeBattle$.MODULE$, LearnSkill$.MODULE$, UseSkill$.MODULE$};
    }
}

